<?php

function oc_admin_bar_init() {
	if (!current_user_can('oc_can_chat') || !is_admin_bar_showing() )
		return;
 
	add_action('admin_bar_menu', 'oc_admin_bar_links', 500);
}


add_action('admin_bar_init', 'oc_admin_bar_init');

function oc_admin_bar_links() {
	global $wp_admin_bar;
 
	ob_start();
	$return = include 'inc/oc-admin-template.php';
	$chat_output = ob_get_clean();
	
 	$wp_admin_bar->add_menu(
 		array(
			'title' => '<span class="ab-icon"></span><span class="ab-label">Online Chat</span>',
			'href' => false,
			'id' => 'oc-admin-chat-title',
			'href' => false,
			'meta' => array(
				'html' => $chat_output,
				'class' => 'oc-title'
			)
		));
		
}


add_action( 'show_user_profile', 'my_show_extra_profile_fields' );
add_action( 'edit_user_profile', 'my_show_extra_profile_fields' );

function my_show_extra_profile_fields( $user ) { 
	global $status_array;
	$status = get_user_meta( $user->ID,'oc_user_status', true);
	$status = (!empty($status)) ? $status : 0;
	
	if(user_can($user->ID,'oc_can_chat')){
	?>

	<h3>Online Chat Settings</h3>

	<table class="form-table">

		<tr>
			<th><label for="oc_status">Online Status</label>
				
			
			</th>

			<td>
				<fieldset>
					<legend class="screen-reader-text"><span>Status</span></legend>
					<label for="oc_user_status">
					<?php
						foreach($status_array as $k=>$v){
							echo "<input type='radio' name='oc_user_status' value='$k' ".checked( $k, $status, false )."/> $v<br />";
						
						}
					?>
					</label><br>
				</fieldset>
				<?php if(current_user_can('manage_options')):?>
				<a href='admin.php?page=oc_chat_manager&oc_user=<?php echo $user->ID;?>&oc_is_visitor=false&oc_profile=<?php echo $user->ID;?>'>View Chat Threads</a>
				<?php endif;?>
			</td>
		</tr>
	</table>
<?php 
	}
}

add_action( 'personal_options_update', 'my_save_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'my_save_extra_profile_fields' );

function my_save_extra_profile_fields( $user_id ) {

	if ( !current_user_can( 'edit_user', $user_id ) )
		return false;
	
	update_user_meta( $user_id, 'oc_user_status', $_POST['oc_user_status'] );
}